﻿<%@ Page Title="Menu Administration" Language="C#" MasterPageFile="~/Site.Master" AutoEventWireup="true" CodeBehind="Menu.aspx.cs" Inherits="VIRP_WEB.Admin.Menu" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
        <ContentTemplate>

            <asp:Label ID="lblPageTitle" runat="server" Text="Menu Administration" Font-Size="X-Large" />
            <br /><br />
            <asp:Label ID="lblResult" runat="server" ForeColor="Red" />

            <asp:Label ID="lblRegistries" runat="server" Text="Available Registries" AssociatedControlID="listRegistries" />&nbsp;&nbsp;
            <asp:DropDownList ID="listRegistries" runat="server" ToolTip="Select to manage Menu Items for a Registry" 
                DataSourceID="dsRegistries" DataValueField="ID" DataTextField="NAME" AutoPostBack="true" OnDataBound="ListRegistries_DataBound" OnSelectedIndexChanged="ListRegistries_SelectedIndexChanged" />
            <asp:ObjectDataSource ID="dsRegistries" runat="server" TypeName="VIRP_WEB.BaseCode.ServiceInterfaceManager" SelectMethod="STD_REGISTRY_GET_ALL_NON_SYSTEM_BY_USER" OnSelecting="DsRegistries_Selecting" />

            &nbsp;&nbsp;

            <asp:Label ID="lblRoles" runat="server" Text="Available Roles" AssociatedControlID="listRoles" />&nbsp;&nbsp;
            <asp:DropDownList ID="listRoles" runat="server" ToolTip="Select to manage Menu Items for a Role" 
                DataSourceID="dsRoles" DataValueField="ID" DataTextField="NAME" AutoPostBack="true" OnDataBound="ListRoles_DataBound" OnSelectedIndexChanged="ListRoles_SelectedIndexChanged" />
            <asp:ObjectDataSource ID="dsRoles" runat="server" TypeName="VIRP_WEB.BaseCode.ServiceInterfaceManager" SelectMethod="STD_ROLE_GET_ALL_REGISTRY_ROLES" OnSelecting="DsRoles_Selecting" />

            <br /><br /><br /><br />

            <asp:LinkButton ID="linkPages" runat="server" Text="Pages" ToolTip="Select to manage available pages in the system" style="padding:4px; border:1px solid white;" OnClick="LinkPages_Click" />&nbsp;
            <asp:LinkButton ID="linkMenus" runat="server" Text="Menu Items" ToolTip="Select to manage menu items for existing registries" style="padding:4px; border:1px solid white;" OnClick="LinkMenus_Click" />

            <br /><br />

            <asp:Panel ID="pnlPageContainer" runat="server" style="padding:4px; border:1px solid white;">
                <asp:Label ID="lblPageItems" runat="server" Text="Search By" AssociatedControlID="ddlPageItems" />&nbsp;&nbsp;
                <asp:DropDownList ID="ddlPageItems" runat="server" ToolTip="Select to filter column view results" AutoPostBack="false">
                    <asp:ListItem Text="Page Name" Value="NAME"></asp:ListItem>
                    <asp:ListItem Text="Display Text" Value="DISPLAY_TEXT"></asp:ListItem>
                    <asp:ListItem Text="URL" Value="URL"></asp:ListItem>
                    <asp:ListItem Text="Core Page" Value="CORE_PAGE"></asp:ListItem>
                </asp:DropDownList>
                <asp:TextBox runat="server" ToolTip="Enter Search Text" ID="txtPageItems" Width="120px"></asp:TextBox>
                <asp:Button runat="server" ID="btnFilter" ToolTip="Select to begin search" OnClick="BtnFilter_Click" Text="Search" />
                <asp:Button runat="server" ID="btnClear" ToolTip="Select to clear search" OnClick="BtnClear_Click" Text="Clear" />
                <br /><br />
                <asp:Panel ID="pnlPages" runat="server">
                    <asp:GridView ID="gridPages" runat="server" CssClass="gridWizard" PagerStyle-CssClass="pager" EmptyDataRowStyle-CssClass="gridRegistryEmpty" 
                        EmptyDataText="Currently no existing pages are available" AllowSorting="true" Caption="VIRP Menu Pages"
                        DataSourceID="dsPages" AutoGenerateColumns="false" AllowPaging="true" PageSize="10">
                        <Columns>
                            <asp:TemplateField>
                                <ItemTemplate>
                                    <asp:LinkButton ID="linkPageEdit" runat="server" Text="Edit" OnClick="LinkPageEdit_Click" CommandArgument='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("PAGE_ID")) %>' ToolTip="Select to edit page" />
                                    &nbsp;
                                    <asp:LinkButton ID="linkPageDelete" runat="server" Text="Delete" OnClick="LinkPageDelete_Click" CommandArgument='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("PAGE_ID")) %>' ToolTip="Select to delete page" />
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:BoundField SortExpression="NAME" HeaderStyle-ForeColor="White" AccessibleHeaderText="Page Name" HeaderText="Page Name" DataField="NAME" />
                            <asp:BoundField SortExpression="DISPLAY_TEXT" HeaderStyle-ForeColor="White" AccessibleHeaderText="Display Text" HeaderText="Display Text" DataField="DISPLAY_TEXT" />
                            <asp:BoundField SortExpression="URL" HeaderStyle-ForeColor="White" AccessibleHeaderText="URL" HeaderText="URL" DataField="URL" />
                            <asp:BoundField SortExpression="CORE_PAGE" HeaderStyle-ForeColor="White" AccessibleHeaderText="Core Page" HeaderText="Core Page" DataField="CORE_PAGE" />
                        </Columns>
                    </asp:GridView>
                    <asp:ObjectDataSource ID="dsPages" runat="server" TypeName="VIRP_WEB.BaseCode.ServiceInterfaceManager" SelectMethod="STD_WEB_PAGES_GET_ALL" OnSelecting="DsPages_Selecting" SortParameterName="SORT_EXPRESSION" />
                    <br />  
                    <asp:LinkButton ID="linkPageAdd" runat="server" Text="Add New Page" OnClick="LinkPageAdd_Click" ToolTip="Select to add a new page" />
                </asp:Panel>
                <asp:Panel ID="pnlPage" runat="server">
                    <asp:HiddenField ID="hidePageId" runat="server" />
                    <asp:Table ID="tblPageInfo" runat="server">
                        <asp:TableRow>
                            <asp:TableCell><asp:Label ID="lblName" runat="server" Text="Page Name (required field)" AssociatedControlID="txtName" />&nbsp;&nbsp;</asp:TableCell>
                            <asp:TableCell><asp:TextBox ID="txtName" runat="server" MaxLength="50" Width="400" ToolTip="Enter a value for Page Name" /></asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow><asp:TableCell ColumnSpan="2">&nbsp;</asp:TableCell></asp:TableRow>
                        <asp:TableRow>
                            <asp:TableCell><asp:Label ID="lblDisplayText" runat="server" Text="Display Text (required field)" AssociatedControlID="txtDisplayText" />&nbsp;&nbsp;</asp:TableCell>
                            <asp:TableCell><asp:TextBox ID="txtDisplayText" runat="server" MaxLength="50" Width="400" ToolTip="Enter a value for Display Text" /></asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow><asp:TableCell ColumnSpan="2">&nbsp;</asp:TableCell></asp:TableRow>
                        <asp:TableRow>
                            <asp:TableCell><asp:Label ID="lblUrl" runat="server" Text="URL (required field)" AssociatedControlID="txtUrl" />&nbsp;&nbsp;</asp:TableCell>
                            <asp:TableCell><asp:TextBox ID="txtUrl" runat="server" MaxLength="500" Width="400" ToolTip="Enter a value for URL" /></asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow><asp:TableCell ColumnSpan="2">&nbsp;</asp:TableCell></asp:TableRow>
                        <asp:TableRow>
                            <asp:TableCell><asp:Label ID="lblCorePage" runat="server" Text="Core Page" AssociatedControlID="listCorePage" />&nbsp;&nbsp;</asp:TableCell>
                            <asp:TableCell><asp:DropDownList ID="listCorePage" runat="server" Width="404" ToolTip="Select a value for Core Page"><asp:ListItem Text="False" Value="false" /><asp:ListItem Text="True" Value="true" /></asp:DropDownList></asp:TableCell>
                        </asp:TableRow>
                    </asp:Table>

                    <br />

                    <asp:Table ID="tblSavePage" runat="server">
                        <asp:TableRow>
                            <asp:TableCell>
                                <asp:Button ID="btnSavePage" runat="server" Text="Save" OnClick="BtnSavePage_Click" ToolTip="Select to save all page values" />
                                &nbsp;&nbsp;
                                <asp:Button ID="btnCancelPage" runat="server" Text="Return to List" OnClick="BtnCancelPage_Click" ToolTip="Select to cancel changes and return to Page list" />
                            </asp:TableCell>
                        </asp:TableRow>
                    </asp:Table>
                </asp:Panel>
            </asp:Panel>
            <asp:Panel ID="pnlMenuContainer" runat="server" style="padding:4px; border:1px solid white;">
                <asp:Panel ID="pnlMenuItems" runat="server">
                    <asp:Label ID="LblMenuItems" runat="server" Text="Search By" AssociatedControlID="ddlMenuItems" />&nbsp;&nbsp;
                    <asp:DropDownList ID="ddlMenuItems" runat="server" ToolTip="Select to filter column view results" 
                        AutoPostBack="false">
                        <asp:ListItem Text="Registry" Value="STD_REGISTRY.NAME"></asp:ListItem>
                        <asp:ListItem Text="Page Name" Value="STD_WEB_PAGES.NAME"></asp:ListItem>
                        <asp:ListItem Text="Menu Item Name" Value="MENU_PAGE.NAME"></asp:ListItem>
                        <asp:ListItem Text="Role Name" Value="STD_ROLE.NAME"></asp:ListItem>
                        <asp:ListItem Text="Sort Order" Value="SORT_ORDER"></asp:ListItem>
                    </asp:DropDownList>
                    <asp:TextBox runat="server" ToolTip="Enter Search Text" ID="txtMenuItems" Width="120px"></asp:TextBox>
                    <asp:Button runat="server" ToolTip="Select to begin search" ID="btnMenuItems" OnClick="BtnMenuItems_Click" Text="Search" />
                    <asp:Button runat="server" ToolTip="Select to clear search" ID="btnClearMenuItems" OnClick="BtnClearMenuItems_Click" Text="Clear" />
                    <br /><br />
                    <asp:GridView ID="gridMenuItems" runat="server" CssClass="gridWizard" PagerStyle-CssClass="pager" EmptyDataRowStyle-CssClass="gridRegistryEmpty"
                        EmptyDataText="Currently no existing menu items are available.<br /><br />Please select an existing Registry from the Available Registries dropdown list if not already selected." AllowSorting="true" Caption="VIRP Menu Items"
                        DataSourceID="dsMenuItems" AutoGenerateColumns="false" AllowPaging="true" PageSize="10">
                        <Columns>
                            <asp:TemplateField>
                                <ItemTemplate>
                                    <asp:LinkButton ID="linkMenuEdit" runat="server" Text="Edit" OnClick="LinkMenuEdit_Click" CommandArgument='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("MENU_ID")) %>' ToolTip="Select to edit menu item" />
                                    &nbsp;
                                    <asp:LinkButton ID="linkMenuDelete" runat="server" Text="Delete" OnClick="LinkMenuDelete_Click" CommandArgument='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("MENU_ID")) %>' ToolTip="Select to delete menu item" />
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:BoundField HeaderStyle-ForeColor="White" AccessibleHeaderText="Registry" HeaderText="Registry" SortExpression="STD_REGISTRY.NAME" DataField="STD_REGISTRY.NAME" />
                            <asp:BoundField HeaderStyle-ForeColor="White" AccessibleHeaderText="Page Name" HeaderText="Page Name" SortExpression="STD_WEB_PAGES.NAME" DataField="STD_WEB_PAGES.NAME" />
                            <asp:BoundField HeaderStyle-ForeColor="White" AccessibleHeaderText="Menu Item Name" HeaderText="Menu Item Name" SortExpression="MENU_PAGE.NAME" DataField="MENU_PAGE.NAME" />
                            <asp:BoundField HeaderStyle-ForeColor="White" AccessibleHeaderText="Role Name" HeaderText="Role Name" SortExpression="STD_ROLE.NAME" DataField="STD_ROLE.NAME" />
                            <asp:BoundField HeaderStyle-ForeColor="White" AccessibleHeaderText="Sort Order" HeaderText="Sort Order" SortExpression="SORT_ORDER" DataField="SORT_ORDER" />
                        </Columns>
                    </asp:GridView>
                    <asp:ObjectDataSource ID="dsMenuItems" runat="server" TypeName="VIRP_WEB.BaseCode.ServiceInterfaceManager" SelectMethod="STD_MENU_ITEMS_GET_ALL_BY_REGISTRY" OnSelecting="DsMenuItems_Selecting" SortParameterName="SORT_EXPRESSION" />
                    <br />  
                    <asp:LinkButton ID="linkMenuAdd" runat="server" Text="Add New Menu Item" OnClick="LinkMenuAdd_Click" ToolTip="Select to add a new menu item" />
                </asp:Panel>
                <asp:Panel ID="pnlMenuItem" runat="server">
                    <asp:HiddenField ID="hideMenuId" runat="server" />
                    <asp:Table ID="tblMenuItemInfo" runat="server">
                        <asp:TableRow>
                            <asp:TableCell><asp:Label ID="lblPageName" runat="server" Text="Page Name" AssociatedControlID="listPageName" />&nbsp;&nbsp;</asp:TableCell>
                            <asp:TableCell>
                                <asp:DropDownList ID="listPageName" runat="server" Width="405" ToolTip="Select a Page Name value" DataSourceID="dsPageName" DataValueField="PAGE_ID" DataTextField="NAME" OnDataBound="ListPageName_DataBound" />
                                <asp:ObjectDataSource ID="dsPageName" runat="server" TypeName="VIRP_WEB.BaseCode.ServiceInterfaceManager" SelectMethod="STD_WEB_PAGES_GET_ALL" OnSelecting="Ds_Selecting" /></asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow><asp:TableCell ColumnSpan="2">&nbsp;</asp:TableCell></asp:TableRow>
                        <asp:TableRow>
                            <asp:TableCell><asp:Label ID="lblMenuPageName" runat="server" Text="Menu Item Name" AssociatedControlID="listMenuPageName" />&nbsp;&nbsp;</asp:TableCell>
                            <asp:TableCell>
                                <asp:DropDownList ID="listMenuPageName" runat="server" Width="405" ToolTip="Select a Menu Item Name value" DataSourceID="dsMenuPageName" DataValueField="PAGE_ID" DataTextField="NAME" OnDataBound="ListMenuPageName_DataBound" />
                                <asp:ObjectDataSource ID="dsMenuPageName" runat="server" TypeName="VIRP_WEB.BaseCode.ServiceInterfaceManager" SelectMethod="STD_WEB_PAGES_GET_ALL" OnSelecting="Ds_Selecting" /></asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow><asp:TableCell ColumnSpan="2">&nbsp;</asp:TableCell></asp:TableRow>
                        <asp:TableRow>
                            <asp:TableCell><asp:Label ID="lblRoleName" runat="server" Text="Role Name" AssociatedControlID="listRoleName" />&nbsp;&nbsp;</asp:TableCell>
                            <asp:TableCell>
                                <asp:DropDownList ID="listRoleName" runat="server" Width="405" ToolTip="Select a Role Name value" DataSourceID="dsRoleName" DataValueField="ID" DataTextField="NAME" OnDataBound="ListRoleName_DataBound" />
                                <asp:ObjectDataSource ID="dsRoleName" runat="server" TypeName="VIRP_WEB.BaseCode.ServiceInterfaceManager" SelectMethod="STD_ROLE_GET_ALL_REGISTRY_ROLES" OnSelecting="DsRoleName_Selecting" /></asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow><asp:TableCell ColumnSpan="2">&nbsp;</asp:TableCell></asp:TableRow>
                        <asp:TableRow>
                            <asp:TableCell><asp:Label ID="lblSortOrder" runat="server" Text="Sort Order (required field)" AssociatedControlID="txtSortOrder" />&nbsp;&nbsp;</asp:TableCell>
                            <asp:TableCell><asp:TextBox ID="txtSortOrder" runat="server" MaxLength="50" Width="400" ToolTip="Enter a value for Sort Order" onkeypress="return CheckNumeric(event);" /></asp:TableCell>
                        </asp:TableRow>
                    </asp:Table>

                    <br />

                    <asp:Table ID="tblSaveMenu" runat="server">
                        <asp:TableRow>
                            <asp:TableCell>
                                <asp:Button ID="btnSaveMenu" runat="server" Text="Save" OnClick="BtnSaveMenu_Click" ToolTip="Select to save all menu values" />
                                &nbsp;&nbsp;
                                <asp:Button ID="btnCancelMenu" runat="server" Text="Return to List" OnClick="BtnCancelMenu_Click" ToolTip="Select to cancel changes and return tomMenu list" />
                            </asp:TableCell>
                        </asp:TableRow>
                    </asp:Table>
                </asp:Panel>
            </asp:Panel>
        </ContentTemplate>
    </asp:UpdatePanel>
    
    <asp:UpdateProgress ID="UpdateProgress1" AssociatedUpdatePanelID="UpdatePanel1" runat="server" DisplayAfter="0"> 
    <ProgressTemplate> 
        <div id="modalDiv" class="delayModalStyle" style="position:fixed; height:100%; width: 100%; top:0; left:0; z-index: 100;"> 
        &nbsp; 
        </div>
        <div id="delayIndicatorDiv" class="delayIndicatorStyle" style="position:fixed; top:50%; left:40%; z-index:1003;"> 
            <img alt="" src="../Images/ajax-loader.gif" />
            Processing request. Please wait.
        </div> 
    </ProgressTemplate> 
    </asp:UpdateProgress>

</asp:Content>
